#include <bits/stdc++.h>
using namespace std;

const int MAXN = 200005;
int bit[MAXN], cnt[MAXN];

void add(int idx, int val){
    for(int i = idx; i < MAXN; i += i & -i) bit[i] += val;
}

int query(int idx){
    int res = 0;
    for(int i = idx; i > 0; i -= i & -i) res += bit[i];
    return res;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    vector<int> a(N+1);
    for(int i = 1; i <= N; i++) {
        cin >> a[i];
        cnt[i] = 0;
    }

    while(Q--){
        int t;
        cin >> t;
        if(t == 1){
            int k;
            cin >> k;
            vector<int> freq(MAXN,0);
            for(int i = 1; i <= k; i++) freq[a[i]]++;
            long long sum = 0;
            for(int i = 1; i < MAXN; i++){
                if(freq[i] % 2 == 1) sum += i;
            }
            cout << sum << "\n";
        } else {
            int x, y;
            cin >> x >> y;
            a[x] = y;
        }
    }
    return 0;
}